Attribute VB_Name = "basHTMLReport"
' vb@rchiv - Das groe Visual-Basic Archiv
' Tools & Components - Entwicklerkomponenten fr VB-32 Bit
'
' Copyright 2000-2001 Dieter Otter
'
' Der Programmcode darf fr eigene Zwecke verwendet werden.
' Es ist nicht erlaubt Inhalte des Projektes ohne unserer
' Zustimmung zum Download anzubieten.
'
' Die Beispielskripte sind Computerprogramme, die gem
' des 2 Abs. 1 Nr. 69 aff. UrhG den urheberrechtlichen
' Schutz geniessen und drfen nicht fr eigene ausgegeben
' werden.
'
' Dieter Otter
' Software-Entwicklung & Vertrieb
' info@vbarchiv.de
' http://www.vbarchiv.de
' http://www.visualbasic-archiv.de
'
' info@tools4vb.de
' http://www.tools4vb.de
'======================================================
Option Explicit
Private Declare Function ShellExecute Lib "shell32.dll" _
  Alias "ShellExecuteA" (ByVal hWnd As Long, _
  ByVal lpOperation As String, _
  ByVal lpFile As String, _
  ByVal lpParameters As String, _
  ByVal lpDirectory As String, _
  ByVal nShowCmd As Long) As Long

' Auslesen einer Datenbank-Tabelle
' und Erstellen eines HTML-Berichts.
'
' Die Tabellen-Feldnamen dienen gleichzeitg
' der Benennung der Spalten in der HTML-Tabelle
'
' Optional:
' Titel      Titel der HTML-Seite (erscheint in der
'            Titelleiste des Browsers)
'            Vorgabe: Tabellen-Name der Datenbank
'
' tabTitel   Tabellen-berschrift
'            Vorgabe: Tabellen-Name der Datenbank
'
' ItemsPerPage  Anzahl Datenstze (Zeilen) pro Seite
'               (Wird ItemsPerPage nicht angegeben,
'               wird nur eine einzige Datei erzeugt)
'
'======================================================

Public Sub dbTableToHTML(Tabelle As Recordset, _
  ByVal Filename As String, _
  Optional ByVal Titel As String = "", _
  Optional ByVal tabTitel As String = "", _
  Optional ByVal ItemsPerPage As Integer = 0)
  
  Dim F As Integer
  Dim I As Integer
  Dim nRows As Long
  Dim Row As Long
  Dim tCount As Long
  Dim nPages As Integer
  Dim Page As Integer
  Dim Ext As String
  
  ' Standardvorgaben
  If Titel = "" Then Titel = Tabelle.Name
  If tabTitel = "" Then tabTitel = Tabelle.Name
  
  ' HTML-Extension
  Ext = Mid$(Filename, InStrRev(Filename, "."))
  Filename = Left$(Filename, Len(Filename) - Len(Ext))
  
  ' Anzahl bentigter Seiten (Dateien)
  Page = 1: nRows = Tabelle.RecordCount
  If (ItemsPerPage > 0) Then
    nPages = Int(nRows / ItemsPerPage)
    If nRows Mod ItemsPerPage <> 0 Then
      nPages = nPages + 1
    End If
  End If
  
  ' HTML-Datei ffnen, Header und berschrift schreiben
  F = HTMLOpenFile(Filename, Ext, Titel, tabTitel, _
    Page, nPages)

  ' Feldnamen dienen als Spaltenbezeichner fr die Tabelle
  HTMLBegTableDef F, Tabelle

  ' Datenstze durchlaufen
  With Tabelle
    Do While Not .EOF
      ' aktuelle Anzahl Datenstze pro Datei mitzhlen
      Row = Row + 1
      If Row > ItemsPerPage And ItemsPerPage > 0 Then
        ' Jetzt neue HTML-Seite
        HTMLEndTableDef F, Filename, Ext, tCount, _
          Page, Page + 1
        HTMLCloseFile F
        Page = Page + 1
        Row = 1
        F = HTMLOpenFile(Filename, Ext, Titel, tabTitel, _
          Page, nPages)
        HTMLBegTableDef F, Tabelle
      End If
        
      ' Tabellen-Spalten fllen
      tCount = tCount + 1
      Print #F, "<TR>";
      For I = 0 To .Fields.Count - 1
        Print #F, "  <TD>";
        Print #F, txt2html(.Fields(I).Value);
        Print #F, "</TD>"
      Next I
      Print #F, "</TR>";

      .MoveNext
    Loop
  End With
  
  ' Tabellendefintion abschliessen
  HTMLEndTableDef F, Filename, Ext, tCount, _
    Page, nPages
  HTMLCloseFile F
End Sub

' Tabellen-Definition in HTML-Datei schreiben
' Feldnamen der Tabelle dienen gleichzeitig der
' Bezeichnung der HTML-Tabellenspalten
' Optional: Eigene Spaltenberschriften
'   Hierzu im sOwnHeader-Parameter die Spaltentitel getrennt
'   mit vbTab bergeben
Private Sub HTMLBegTableDef(F As Integer, _
  Tabelle As Recordset, Optional ByVal sOwnHeader As String = "")
  
  Dim I As Integer
  Dim sTitel() As String
  
  Print #F, "<TABLE WIDTH=100% CELLPADDING=0 " & _
    "CELLSPACING=2 BORDER=0>"
    
  With Tabelle
    ' Eigene Titelzeile (mit freien Spalten-berschriften)
    If sOwnHeader <> "" Then
      sTitel = Split(sOwnHeader, vbTab)
      If UBound(sTitel) <> .Fields.Count - 1 Then
        ReDim Preserve sTitel(.Fields.Count - 1)
      End If
    Else
      ReDim sTitel(.Fields.Count - 1)
    End If
    
    Print #F, "<TR BGCOLOR=#D7D7D7>"
    For I = 0 To .Fields.Count - 1
      Print #F, "  <TH>";
      Print #F, IIf(sTitel(I) = "", .Fields(I).Name, sTitel(I));
      Print #F, "</TH>"
    Next I
    Print #F, "</TR>"
  End With
End Sub

' HTML-Datei abschlieen
Private Sub HTMLCloseFile(F As Integer)
  Print #F, "</BODY>"
  Print #F, "</HTML>"
  Close #F
End Sub

' Tabellen abschlieen
' GGf. autom. Links zum Blttern einfgen
Private Sub HTMLEndTableDef(F As Integer, _
  Filename As String, Ext As String, _
  ByVal tCount As Long, ByVal Page As Integer, _
  Optional ByVal PageNext As Integer = 0)
  
  Print #F, "</TABLE>"
  Print #F, "<P><B>Anzahl Datenstze: " & _
    Format$(tCount) & "</B></P>"
  
  ' Navigationsleiste unterhalb der Tabelle
  If Page > 1 Or PageNext <> 0 Then
    Print #F, "<HR SIZE=1>"
    Print #F, "<P>";
    
    ' Link zum Zurckblttern
    If Page > 1 Then
      Print #F, "<A HREF=""" & Filename & _
        IIf(Page - 1 <> 1, "-" & Format$(Page - 1), "") & _
        Ext & """>Zurck</A>";
      Print #F, "&nbsp;&nbsp;|&nbsp;&nbsp;";
    End If
    
    ' Link zum Vorblttern
    If PageNext <> 0 Then
      Print #F, "<A HREF=""" & Filename & "-" & _
      Format$(PageNext) & Ext & """>Weiter</A>";
    End If
    Print #F, "</P>"
  End If
End Sub

' ffnet eine HTML-Datei und schreibt die
' HTML-Header-Informationen
Private Function HTMLOpenFile(ByVal Filename As String, _
  ByVal Ext As String, ByVal Titel As String, _
  ByVal tabTitel As String, ByVal Page As Integer, _
  ByVal nPages As Integer) As Integer
  
  Dim F As Integer
  
  F = FreeFile
  Open Filename & IIf(Page > 1, "-" + Format$(Page), _
    "") & Ext For Output As #F

  ' Header-Informationen
  Print #F, "<HTML>"
  Print #F, "<HEAD>"
  Print #F, "<TITLE>" & Titel & "</TITLE>"
  Print #F, "</HEAD>"

  Print #F, "<BODY TEXT=#000000 BGCOLOR=#FFFFFF>"
  Print #F, "<FONT NAME=""ARIAL"">"
  Print #F, "<H1>" & tabTitel & "</H1>"
  
  ' Ggf. Seite x von y ausgeben
  If nPages > 1 Then
    Print #F, "<p><b>Seite " & Format$(Page, "0") & _
      " von " & Format$(nPages, "0") & "</b></p>"
  End If
  
  HTMLOpenFile = F
End Function
'Text in HTML-Text umwandeln
Private Function txt2html(sText As String) As String

  'Text-Datei zeilenweise einlesen
  'und Sonderzeichen, wie Umlaute und spitze
  'Klammern durch HTML-Steuercodes ersetzen
  
  sText = Replace(sText, "", "&auml;")
  sText = Replace(sText, "", "&Auml;")
  sText = Replace(sText, "", "&ouml;")
  sText = Replace(sText, "", "&Ouml;")
  sText = Replace(sText, "", "&uuml;")
  sText = Replace(sText, "", "&Uuml;")
  sText = Replace(sText, "", "&szlig;")
  sText = Replace(sText, ">", "&gt;")
  sText = Replace(sText, "<", "&lt;")
  sText = Replace(sText, Chr$(34), "&quot;")

  txt2html = sText
End Function



' HTML-Report im Standard-Browser anzeigen
Public Sub HTMLShowReport(ByVal hWnd As Long, _
  ByVal Filename As String)
  
  ShellExecute hWnd, "open", Filename, vbNullString, _
    vbNullString, vbNormalFocus
End Sub
