VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsINI"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'+-------------------------------------------+---------------+
'| clsINI.cls (SCWlib: clsINI)               | Version 0.9.0 |
'+-------------------------------------------+---------------+
'| Copyright (C) 2002 - Tim "LGm" Gerundt (lgm@lgmsworld.de) |
'+-----------------------------------------------------------+
Option Explicit

Private Declare Function GetPrivateProfileInt Lib "kernel32.dll" Alias "GetPrivateProfileIntA" (ByVal lpApplicationName As String, ByVal lpKeyName As String, ByVal nDefault As Long, ByVal lpFileName As String) As Long
Private Declare Function GetPrivateProfileString Lib "kernel32.dll" Alias "GetPrivateProfileStringA" (ByVal lpApplicationName As String, ByVal lpKeyName As Any, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Long, ByVal lpFileName As String) As Long
Private Declare Function WritePrivateProfileString Lib "kernel32.dll" Alias "WritePrivateProfileStringA" (ByVal lpApplicationName As String, ByVal lpKeyName As Any, ByVal lpString As Any, ByVal lpFileName As String) As Long

'Private FSO As New FileSystemObject
Private INIFile As String
'Wenn die Klasse erstellt wird...
Private Sub Class_Initialize()
  '...
  '...
  '...
End Sub
'Wenn die Klasse entladen wird...
Private Sub Class_Terminate()
  'Set FSO = Nothing
  INIFile = ""
End Sub
'Einstellung "Datei" lesen...
Public Property Get File() As String
Attribute File.VB_Description = "Pfad der INI-Datei."
  File = INIFile
End Property
'Einstellung "Datei" schreiben...
Public Property Let File(ByVal Path As String)
Attribute File.VB_Description = "Pfad der INI-Datei."
  INIFile = Path
End Property
'Datei vorhanden?..
Public Function FileExists() As Boolean
Attribute FileExists.VB_Description = "berprfen, ob die INI-Datei existiert."
  'FileExists = FSO.FileExists(INIFile)
  If (Dir(INIFile) <> "") Then 'Wenn die Datei vorhanden ist...
    FileExists = True 'Rckgabewert = Wahr [1]
  Else 'Wenn die Datei vorhanden ist...
    FileExists = False 'Rckgabewert = Falsch [0]
  End If
End Function
'Integer-Wert aus Datei lesen...
Public Function ReadKeyValueInt(ByVal Section As String, ByVal Key As String, Optional ByVal Default As Long = 0) As Long
Attribute ReadKeyValueInt.VB_Description = "Liest einen Integer-Wert aus der INI-Datei."
  ReadKeyValueInt = GetPrivateProfileInt(Section, Key, Default, INIFile) 'Rckgabewert = "Value"
End Function
'Boolean-Wert aus Datei lesen...
Public Function ReadKeyValueBool(ByVal Section As String, ByVal Key As String, Optional ByVal Default As Boolean = False) As Boolean
Attribute ReadKeyValueBool.VB_Description = "Liest einen Boolean-Wert aus der INI-Datei."
  Dim lDefault As Long

  If (Default = False) Then lDefault = 0 Else lDefault = 1
  ReadKeyValueBool = CBool(GetPrivateProfileInt(Section, Key, lDefault, INIFile)) 'Rckgabewert = "Value"
End Function
'String-Wert aus Datei lesen...
Public Function ReadKeyValueStr(ByVal Section As String, ByVal Key As String, Optional ByVal Default As String = "") As String
Attribute ReadKeyValueStr.VB_Description = "Liest einen String-Wert aus der INI-Datei."
  Dim lResult As Long, sValue As String

  ReadKeyValueStr = "" 'Rckgabewert = ""
  If (INIFile <> "") Then 'Wenn eine Datei angegeben ist...
    sValue = Space$(255)
    lResult = GetPrivateProfileString(Section, Key, Default, sValue, Len(sValue), INIFile) 'Lese "Value".
    ReadKeyValueStr = Left(sValue, InStr(sValue, Chr(0)) - 1) 'Rckgabewert = "Value"
  End If
End Function
'String-Wert aus Datei lesen...
Public Function ReadKeyValue(ByVal Section As String, ByVal Key As String, Optional ByVal Default As String = "") As String
Attribute ReadKeyValue.VB_Description = "Liest einen String-Wert aus der INI-Datei."
  ReadKeyValue = ReadKeyValueStr(Section, Key, Default) 'Rckgabewert = "Value"
End Function
'Integer-Wert in Datei schreiben...
Public Function WriteKeyValueInt(ByVal Section As String, ByVal Key As String, ByVal Value As Long) As Boolean
Attribute WriteKeyValueInt.VB_Description = "Schreibt einen Integer-Wert in die INI-Datei."
  WriteKeyValueInt = WriteKeyValue(Section, Key, Value) 'Rckgabewert
End Function
'Boolean-Wert in Datei schreiben...
Public Function WriteKeyValueBool(ByVal Section As String, ByVal Key As String, ByVal Value As Boolean) As Boolean
Attribute WriteKeyValueBool.VB_Description = "Schreibt einen Boolean-Wert in die INI-Datei."
  Dim sValue As String

  WriteKeyValueBool = False 'Rckgabewert = Falsch [0]
  If (INIFile <> "") Then 'Wenn eine Datei angegeben ist...
    If (Value = False) Then sValue = 0 Else sValue = 1
    WriteKeyValueBool = WritePrivateProfileString(Section, Key, sValue, INIFile) 'Rckgabewert
  End If
End Function
'String-Wert in Datei schreiben...
Public Function WriteKeyValueStr(ByVal Section As String, ByVal Key As String, ByVal Value As String) As Boolean
Attribute WriteKeyValueStr.VB_Description = "Schreibt einen String-Wert in die INI-Datei."
  WriteKeyValueStr = WriteKeyValue(Section, Key, Value) 'Rckgabewert
End Function
'Wert in Datei schreiben...
Public Function WriteKeyValue(ByVal Section As String, ByVal Key As String, ByVal Value As String) As Boolean
Attribute WriteKeyValue.VB_Description = "Schreibt einen String-Wert in die INI-Datei."
  WriteKeyValue = False 'Rckgabewert = Falsch [0]
  If (INIFile <> "") Then 'Wenn eine Datei angegeben ist...
    WriteKeyValue = WritePrivateProfileString(Section, Key, Value, INIFile) 'Rckgabewert
  End If
End Function
'Liefert die Namen aller Abschnitte zurck...
Public Function GetSectionNames(ByRef Section() As String) As Integer
  Dim iResult As Long, sSections As String
  Dim i As Integer, j As Integer, sChar As String, sName As String

  GetSectionNames = 0 'Rckgabewert = [0]
  If (INIFile <> "") Then 'Wenn eine Datei angegeben ist...
    sSections = Space$(32767)
    iResult = GetPrivateProfileString(vbNullString, vbNullString, "", sSections, Len(sSections), INIFile) 'Lese "Value".
    If (sSections <> "") Then 'Wenn Abschnitte gefunden wurden...
      j = -1
      sName = ""
      For i = 0 To (Len(sSections) - 1) 'Fr alle Zeichen durch gehen...
        sChar = Mid(sSections, (i + 1), 1)
        If (sChar <> vbNullChar) Then 'Wenn es KEIN Zeichen mit dem Wert 0 ist...
          sName = sName + sChar
        Else 'Wenn es ein Zeichen mit dem Wert 0 ist...
          If (sName <> "") Then 'Wenn ein Abschnitt ermittelt wurde...
            j = j + 1
            ReDim Preserve Section(j)
            Section(j) = sName 'Abschnitt speichern.
            sName = ""
          End If
        End If
      Next i
      GetSectionNames = (j + 1) 'Rckgabewert = [Abschnitt-Anzahl]
    End If
  End If
End Function
'Liefert die Namen aller Schlssel von einem Abschnitt zurck...
Public Function GetKeyNames(ByVal Section As String, ByRef Key() As String) As Integer
  Dim iResult As Long, sKeys As String
  Dim i As Integer, j As Integer, sChar As String, sName As String

  GetKeyNames = 0 'Rckgabewert = [0]
  If (INIFile <> "") Then 'Wenn eine Datei angegeben ist...
    sKeys = Space$(32767)
    iResult = GetPrivateProfileString(Section, vbNullString, "", sKeys, Len(sKeys), INIFile) 'Lese "Value".
    If (sKeys <> "") Then 'Wenn Schlssel gefunden wurden...
      j = -1
      sName = ""
      For i = 0 To (Len(sKeys) - 1) 'Fr alle Zeichen durch gehen...
        sChar = Mid(sKeys, (i + 1), 1)
        If (sChar <> vbNullChar) Then 'Wenn es KEIN Zeichen mit dem Wert 0 ist...
          sName = sName + sChar
        Else 'Wenn es ein Zeichen mit dem Wert 0 ist...
          If (sName <> "") Then 'Wenn ein Schlssel ermittelt wurde...
            j = j + 1
            ReDim Preserve Key(j)
            Key(j) = sName 'Schlssel speichern.
            sName = ""
          End If
        End If
      Next i
      GetKeyNames = (j + 1) 'Rckgabewert = [Schlssel-Anzahl]
    End If
  End If
End Function
'Lsche "Abschnitt" aus Datei...
Public Function DeleteSection(ByVal Section As String) As Boolean
Attribute DeleteSection.VB_Description = "Lscht einen Abschnitt aus der INI-Datei."
  DeleteSection = False 'Rckgabewert = Falsch [0]
  If (INIFile <> "") Then 'Wenn eine Datei angegeben ist...
    DeleteSection = WritePrivateProfileString(Section, vbNullString, vbNullString, INIFile) 'Rckgabewert
  End If
End Function
'Lsche "Schlssel" aus Datei...
Public Function DeleteKey(ByVal Section As String, ByVal Key As String) As Boolean
Attribute DeleteKey.VB_Description = "Lscht einen Schlssel aus der INI-Datei."
  DeleteKey = False 'Rckgabewert = Falsch [0]
  If (INIFile <> "") Then 'Wenn eine Datei angegeben ist...
    DeleteKey = WritePrivateProfileString(Section, Key, vbNullString, INIFile) 'Rckgabewert
  End If
End Function
