VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsLBTabelle"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Declare Function SetWindowLong Lib "user32" Alias _
   "SetWindowLongA" _
   (ByVal hwnd As Long, ByVal nIndex As Long, _
    ByVal dwNewLong As Long) As Long

Private Declare Function SendMessage Lib "user32" Alias _
   "SendMessageA" _
   (ByVal hwnd As Long, ByVal wMsg As Long, _
    ByVal wParam As Long, lParam As Any) As Long
    
Private Declare Function ShowScrollBar Lib "user32" _
   (ByVal hwnd As Long, ByVal wBar As Long, ByVal bShow As Long) As Long

Private Type RECT
    Left As Long
    Top As Long
    Right As Long
    Bottom As Long
End Type

Private Const GWL_STYLE = (-16)
Private Const WS_VSCROLL = &H200000
Private Const WS_CHILD = &H40000000
Private Const WS_VISIBLE = &H10000000
Private Const WS_CLIPSIBLINGS = &H4000000
Private Const WS_TABSTOP = &H10000
Private Const WS_BORDER = &H800000
Private Const LBS_NOTIFY = &H1&
Private Const LBS_EXTENDEDSEL = &H800&
Private Const WS_EX_NOPARENTNOTIFY = &H4&
Private Const GWL_EXSTYLE = (-20)
Private Const LB_GETITEMRECT = &H198
Private Const LB_GETTOPINDEX = &H18E
Private Const LB_SETTOPINDEX = &H197
Private Const SB_VERT = 1

Private tmpFieldCol As Collection
Private tmpField As Long
Private tmpIndex As Long

Public Property Get Count() As Long
   Count = tmpFieldCol.Count
End Property

Private Sub Class_Initialize()
   Set tmpFieldCol = New Collection
End Sub

Private Sub Class_Terminate()
   Set tmpFieldCol = Nothing
End Sub

Public Sub Add(Item As ListBox, Key As String)
    Dim lb As ListBox
    Dim nLeftPos As Long
    Dim i As Long
    
    For Each lb In tmpFieldCol
       SetStyles lb, 0
       If i = 0 Then nLeftPos = lb.Left
       nLeftPos = nLeftPos + lb.Width
       i = i + 1
    Next
    
    SetStyles Item, 1
    Item.Left = nLeftPos
    Item.Visible = True
    tmpFieldCol.Add Item, Key
End Sub

Public Sub SetStyles(lb As ListBox, ByVal nMode As Byte)
    Select Case nMode
       Case 0
          SetWindowLong lb.hwnd, GWL_STYLE, WS_CHILD Or _
             WS_VISIBLE Or WS_CLIPSIBLINGS Or WS_TABSTOP Or _
             LBS_EXTENDEDSEL
          SetWindowLong lb.hwnd, GWL_EXSTYLE, WS_EX_NOPARENTNOTIFY
       Case 1
          SetWindowLong lb.hwnd, GWL_STYLE, WS_CHILD Or _
             WS_VISIBLE Or WS_CLIPSIBLINGS Or WS_TABSTOP Or _
             WS_VSCROLL
          SetWindowLong lb.hwnd, GWL_EXSTYLE, WS_EX_NOPARENTNOTIFY
    End Select
End Sub

Public Sub Remove(Index As Variant)
    tmpFieldCol.Remove Index
End Sub

Public Sub Item(Index As Variant)
    Set Item = tmpFieldCol.Item(Index)
End Sub

Public Sub SetCursor(ByVal nLbIndex As Long)
   Dim lb As ListBox
   For Each lb In tmpFieldCol
      lb.ListIndex = nLbIndex
   Next
End Sub

Public Sub DeleteRow(ByVal nLbIndex As Long)
   Dim lb As ListBox
   For Each lb In tmpFieldCol
      lb.RemoveItem nLbIndex
   Next
End Sub

Public Sub GetInputBox(ByVal nLbIndex As Long, ByVal Index As Long, tb As TextBox)
   Dim r As RECT
   SendMessage tmpFieldCol.Item(Index).hwnd, LB_GETITEMRECT, nLbIndex, r
   With tb
      .Text = ""
      .Left = tmpFieldCol.Item(Index).Left + r.Left * Screen.TwipsPerPixelX
      .Top = tmpFieldCol.Item(Index).Top + r.Top * Screen.TwipsPerPixelY
      .Width = r.Right * Screen.TwipsPerPixelX
      .Height = r.Bottom * Screen.TwipsPerPixelY - r.Top * Screen.TwipsPerPixelY
      .Visible = True
      .SetFocus
   End With
End Sub

Public Property Get AktFeld() As Long
    AktFeld = tmpField
End Property

Public Property Let AktFeld(ByVal nIndex As Long)
    tmpField = nIndex
End Property

Public Property Get AktIndex() As Long
    AktIndex = tmpIndex
End Property

Public Property Let AktIndex(ByVal nIndex As Long)
    tmpIndex = nIndex
End Property

Public Sub ChangeFieldText(ByVal sText As Variant)
    tmpFieldCol(tmpField).List(tmpIndex) = sText
    If tmpField <> tmpFieldCol.Count Then
       ShowScrollBar tmpFieldCol(tmpField).hwnd, SB_VERT, False
    End If
End Sub

Public Sub LBScroll(ByVal Index As Long)
   Dim nTopItem As Long
   Dim lb As ListBox
   nTopItem = SendMessage(tmpFieldCol(Index).hwnd, LB_GETTOPINDEX, 0, ByVal 0)
   For Each lb In tmpFieldCol
      If lb.Index <> tmpFieldCol.Count Then
        SendMessage lb.hwnd, LB_SETTOPINDEX, nTopItem, ByVal 0
        ShowScrollBar lb.hwnd, SB_VERT, False
      End If
   Next
End Sub

Public Sub ChangeColumnWidth(ByVal Index As Long, ByVal nWidth As Long)
   Dim lb As ListBox
   Dim nLeftPos As Long
   Dim i As Boolean
   
   tmpFieldCol(Index).Width = nWidth
   i = True
   For Each lb In tmpFieldCol
       If Not i Then
          lb.Left = nLeftPos
          nLeftPos = nLeftPos + lb.Width
       Else
          nLeftPos = lb.Left + lb.Width
       End If
       i = False
   Next
End Sub
