Attribute VB_Name = "modCipher"
Option Explicit
' By: David Midkiff (mdj2023@hotmail.com)
' Interface with ebCrypt.dll to access several
' encryption and hash algorithms.

Public Enum Algorithms
    BLOWFISH
    IDEA
    TRIPLEDES
    DES
    DESE
    CAST5
End Enum
Public Enum HashAlgorithms
    RipeMD
    MD5
    SHA1
End Enum

Private Declare Sub CopyMem Lib "kernel32" Alias "RtlMoveMemory" (Destination As Any, Source As Any, ByVal Length As Long)
Private hiByte As Long
Private hiBound As Long
Private byteArray() As Byte
Public Function Hash(Which As HashAlgorithms, Message As String) As String
    If Message = "" Then Exit Function
    Dim hsh As ebCryptLib.eb_c_Hash
    Set hsh = CreateObject("EbCrypt.eb_c_Hash")
    If Which = MD5 Then Hash = hsh.HashString(EB_CRYPT_HASH_ALGORITHM_MD5, Message)
    If Which = SHA1 Then Hash = hsh.HashString(EB_CRYPT_HASH_ALGORITHM_SHA1, Message)
    If Which = RipeMD Then Hash = hsh.HashString(EB_CRYPT_HASH_ALGORITHM_RIPEMD160, Message)
End Function
Public Function EncryptString(Which As Algorithms, Text As String, Optional OutputInHex As Boolean, Optional Key As String, Optional Salt As String) As String
    On Error GoTo errorhandler
    Dim cipher As ebCryptLib.eb_c_Cipher
    Set cipher = New ebCryptLib.eb_c_Cipher
    If Len(Salt) < 8 Then Salt = Salt & Space$(8 - Len(Salt))
    If Which = BLOWFISH Then EncryptString = StrConv(cipher.EncryptString(EB_CRYPT_CIPHER_ALGORITHM_BLOWFISH_OFB, Key, Salt, Text), vbUnicode)
    If Which = CAST5 Then EncryptString = StrConv(cipher.EncryptString(EB_CRYPT_CIPHER_ALGORITHM_CAST5_OFB, Key, Salt, Text), vbUnicode)
    If Which = DES Then EncryptString = StrConv(cipher.EncryptString(EB_CRYPT_CIPHER_ALGORITHM_DES_OFB, Key, Salt, Text), vbUnicode)
    If Which = DESE Then EncryptString = StrConv(cipher.EncryptString(EB_CRYPT_CIPHER_ALGORITHM_DESE_OFB, Key, Salt, Text), vbUnicode)
    If Which = TRIPLEDES Then EncryptString = StrConv(cipher.EncryptString(EB_CRYPT_CIPHER_ALGORITHM_DES3_OFB, Key, Salt, Text), vbUnicode)
    If Which = IDEA Then EncryptString = StrConv(cipher.EncryptString(EB_CRYPT_CIPHER_ALGORITHM_IDEA_OFB, Key, Salt, Text), vbUnicode)
    If OutputInHex = True Then EncryptString = EnHex(EncryptString)
    Exit Function

errorhandler:
MsgBox Err.Description
End Function
Private Property Get GData() As String
    Dim StringData As String
    StringData = Space(hiByte)
    CopyMem ByVal StringData, ByVal VarPtr(byteArray(0)), hiByte
    GData = StringData
End Property
Private Sub Append(ByRef StringData As String, Optional Length As Long)
    Dim DataLength As Long
    If Length > 0 Then DataLength = Length Else DataLength = Len(StringData)
    If DataLength + hiByte > hiBound Then
        hiBound = hiBound + 1024
        ReDim Preserve byteArray(hiBound)
    End If
    CopyMem ByVal VarPtr(byteArray(hiByte)), ByVal StringData, DataLength
    hiByte = hiByte + DataLength
End Sub
Private Sub Reset()
    hiByte = 0
    hiBound = 1024
    ReDim byteArray(hiBound)
End Sub
Private Function DeHex(Data As String) As String
    Dim iCount As Double
    Reset
    For iCount = 1 To Len(Data) Step 2
        Append Chr$(Val("&H" & Mid$(Data, iCount, 2)))
    Next
    DeHex = GData
    Reset
End Function

Private Function EnHex(Data As String) As String
    Dim iCount As Double, sTemp As String
    Reset
    For iCount = 1 To Len(Data)
        sTemp = Hex$(Asc(Mid$(Data, iCount, 1)))
        If Len(sTemp) < 2 Then sTemp = "0" & sTemp
        Append sTemp
    Next
    EnHex = GData
    Reset
End Function
Public Function DecryptString(Which As Algorithms, CipherText As String, Optional IsTextInHex As Boolean, Optional Key As String, Optional Salt As String) As String
    On Error GoTo errorhandler
    Dim cipher As ebCryptLib.eb_c_Cipher, BArray() As Byte
    Set cipher = New ebCryptLib.eb_c_Cipher
    If IsTextInHex = True Then CipherText = DeHex(CipherText)
    If Len(Salt) < 8 Then Salt = Salt & Space$(8 - Len(Salt))
    BArray() = StrConv(CipherText, vbFromUnicode)
    If Which = BLOWFISH Then DecryptString = cipher.DecryptString(EB_CRYPT_CIPHER_ALGORITHM_BLOWFISH_OFB, Key, Salt, BArray())
    If Which = CAST5 Then DecryptString = cipher.DecryptString(EB_CRYPT_CIPHER_ALGORITHM_CAST5_OFB, Key, Salt, BArray())
    If Which = DES Then DecryptString = cipher.DecryptString(EB_CRYPT_CIPHER_ALGORITHM_DES_OFB, Key, Salt, BArray())
    If Which = DESE Then DecryptString = cipher.DecryptString(EB_CRYPT_CIPHER_ALGORITHM_DESE_OFB, Key, Salt, BArray())
    If Which = IDEA Then DecryptString = cipher.DecryptString(EB_CRYPT_CIPHER_ALGORITHM_IDEA_OFB, Key, Salt, BArray())
    If Which = TRIPLEDES Then DecryptString = cipher.DecryptString(EB_CRYPT_CIPHER_ALGORITHM_DES3_OFB, Key, Salt, BArray())
    Exit Function
    
errorhandler:
MsgBox Err.Description
End Function
