﻿Imports System.ComponentModel
Imports System.Collections.ObjectModel

' BindableCollection(Of ) with Find, Sort (1 column)
Public Class BindableCollection(Of T)
    Inherits BindingList(Of T)

    Private _sorted As Boolean = False
    Private _sortDirection As ListSortDirection = ListSortDirection.Ascending
    Private _sortProperty As PropertyDescriptor = Nothing

    Protected Overrides ReadOnly Property IsSortedCore() As Boolean
        Get
            Return _sorted
        End Get
    End Property

    Protected Overrides Sub ApplySortCore(ByVal pd As System.ComponentModel.PropertyDescriptor, ByVal direction As System.ComponentModel.ListSortDirection)
        _sortDirection = direction
        _sortProperty = pd
        Dim list = DirectCast(Me.Items, List(Of T))
        If list Is Nothing Then Return
        list.Sort(New ItemComparer(Of T)(pd, direction))
        _sorted = True
        OnListChanged(New ListChangedEventArgs(ListChangedType.Reset, -1))
    End Sub

    Protected Overrides ReadOnly Property SupportsSortingCore() As Boolean
        Get
            Return True
        End Get
    End Property

    Protected Overrides ReadOnly Property SortPropertyCore() As System.ComponentModel.PropertyDescriptor
        Get
            Return _sortProperty
        End Get
    End Property

    Protected Overrides ReadOnly Property SortDirectionCore() As System.ComponentModel.ListSortDirection
        Get
            Return _sortDirection
        End Get
    End Property

    Protected Overrides ReadOnly Property SupportsSearchingCore() As Boolean
        Get
            Return True
        End Get
    End Property

    Protected Overrides Function FindCore(ByVal prop As System.ComponentModel.PropertyDescriptor, ByVal key As Object) As Integer
        If key.GetType() Is prop.PropertyType Then
            For i As Integer = 0 To Items.Count - 1
                'If DirectCast(prop.GetValue(Items(i)), IComparable).CompareTo(key) = 0 Then
                If prop.GetValue(Items(i)).Equals(key) Then
                    Return i
                End If
            Next
            Return -1
        End If
        Throw New ArgumentException("Incorrect key type")
    End Function

    Public ReadOnly Property SortProperty() As PropertyDescriptor
        Get
            Return _sortProperty
        End Get
    End Property

    Private Class ItemComparer(Of C)
        Implements IComparer(Of C)

        Private _pd As System.ComponentModel.PropertyDescriptor
        Private _direction As Integer

        Public Sub New(ByVal pd As PropertyDescriptor, ByVal direction As ListSortDirection)
            _pd = pd
            _direction = If(direction = ListSortDirection.Ascending, 1, -1)
        End Sub

        Public Function Compare(ByVal x As C, ByVal y As C) As Integer _
          Implements System.Collections.Generic.IComparer(Of C).Compare
            Return _direction * DirectCast(_pd.GetValue(x), IComparable).CompareTo(_pd.GetValue(y))
        End Function
    End Class

End Class