﻿Imports System.ComponentModel
Imports System.Collections.ObjectModel

' (Business) Data Object
Public Class mc
    Implements INotifyPropertyChanged, IEditableObject, IDataErrorInfo

    ' Data fields
    Private _i As Integer
    Private _s As String

    'Initial values
    Private _ii As Integer
    Private _si As String

    Private _hasChanges As Boolean

    ' IEditableObject fields
    Private _io As Integer
    Private _so As String
    Private _editing As Boolean

    ' IDataErrorInfo fields
    Private _itemMessage As String = String.Empty
    Private _propertyMessages As New Dictionary(Of String, String)
    Private _hasErrors As Boolean

    ' External Properties
    Public Property I() As Integer
        Get
            Return _i
        End Get
        Set(ByVal value As Integer)

            If validI(value) AndAlso value <> _i Then
                _i = value
                If _editing Then Return
                OnPropertyChanged(New PropertyChangedEventArgs("I"))
            Else
                SetPropertyMessage("I", "Not in range")
                ItemMessage = "Value incorrect"
            End If
        End Set
    End Property

    Public Property S() As String
        Get
            Return _s
        End Get
        Set(ByVal value As String)
            If validS(_s) AndAlso value <> _s Then
                _s = value
                If _editing Then Return
                OnPropertyChanged(New PropertyChangedEventArgs("S"))
            End If
        End Set
    End Property

    ' Additional Properties
    <System.ComponentModel.Browsable(False)> _
    Public ReadOnly Property HasChanges() As Boolean
        Get
            Return _hasChanges
        End Get
    End Property

    <System.ComponentModel.Browsable(False)> _
    Public ReadOnly Property HasErrors() As Boolean
        Get
            Return _hasErrors
        End Get
    End Property

    ' Constructors
    Public Sub New()
        initPmsgs()
    End Sub

    Public Sub New(ByVal i As Integer, ByVal s As String)
        If validI(i) AndAlso validS(s) Then
            _i = i
            _s = s
            _ii = i
            _si = s
            initPmsgs()
        Else
            Throw New ArgumentException("Invalid value")
        End If
    End Sub

    ' Data validation
    Private Function validI(ByVal i As Integer) As Boolean
        Return i >= 10 AndAlso i <= 100
    End Function

    Private Function validS(ByVal s As String) As Boolean
        Return True
    End Function

    ' IdataErrorInfo methods, properties
    Private Sub initPmsgs()
        _propertyMessages.Add("I", String.Empty)
        _propertyMessages.Add("S", String.Empty)
    End Sub

    Private Sub clearMsgs()
        _propertyMessages("I") = String.Empty
        _propertyMessages("S") = String.Empty
        _itemMessage = String.Empty
        _hasErrors = False
    End Sub

    Private Sub SetPropertyMessage(ByVal propertyName As String, ByVal message As String)
        If _propertyMessages(propertyName) Is Nothing Then Return
        _propertyMessages(propertyName) = message
        _hasErrors = True
    End Sub

    Private Function GetPropertyMessage(ByVal propertyName As String) As String
        Return _propertyMessages(propertyName)
    End Function

    Private Property ItemMessage()
        Get
            Return _itemMessage
        End Get
        Set(ByVal value)
            If value = _itemMessage Then Return
        End Set
    End Property

    ' PropertyChanged Event
    Public Event PropertyChanged(ByVal sender As Object, ByVal e As System.ComponentModel.PropertyChangedEventArgs) Implements System.ComponentModel.INotifyPropertyChanged.PropertyChanged

    Protected Sub OnPropertyChanged(ByVal e As System.ComponentModel.PropertyChangedEventArgs)
        _hasChanges = True
        RaiseEvent PropertyChanged(Me, e)
    End Sub

    ' IEditableObject Methods
    Public Sub BeginEdit() Implements System.ComponentModel.IEditableObject.BeginEdit
        Debug.WriteLine("BeginEdit")
        _editing = True
        _io = _i
        _so = _s
    End Sub

    Public Sub CancelEdit() Implements System.ComponentModel.IEditableObject.CancelEdit
        Debug.WriteLine("CancelEdit")
        If _editing Then
            _i = _io
            _s = _so
        End If
        _editing = False
    End Sub

    Public Sub EndEdit() Implements System.ComponentModel.IEditableObject.EndEdit
        Debug.WriteLine("EndEdit")
        If _editing Then
            _editing = False
            If _i <> _io Then
                OnPropertyChanged(New PropertyChangedEventArgs("I"))
            End If
            If _s <> _so Then
                OnPropertyChanged(New PropertyChangedEventArgs("S"))
            End If
        End If
    End Sub

    ' IDataErrorInfo
    <System.ComponentModel.Browsable(False)> _
    Public ReadOnly Property [Error]() As String Implements System.ComponentModel.IDataErrorInfo.Error
        Get
            Return ItemMessage
        End Get
    End Property

    <System.ComponentModel.Browsable(False)> _
    Default Public ReadOnly Property Item(ByVal columnName As String) As String Implements System.ComponentModel.IDataErrorInfo.Item
        Get
            Return _propertyMessages(columnName)
        End Get
    End Property

    ' Get DataGridView Display Columns
    Public Shared Function GetViewColumns(ByVal names As String()) As DataGridViewColumn()

        Dim col1 As New DataGridViewTextBoxColumn()
        col1.DisplayIndex = 0
        col1.HeaderText = "I"
        col1.Name = "I"
        col1.ValueType = GetType(Integer)
        col1.DataPropertyName = "I"

        Dim col2 As New DataGridViewTextBoxColumn()
        col2.DisplayIndex = 1
        col2.HeaderText = "S"
        col2.Name = "S"
        col2.ValueType = GetType(String)
        col2.DataPropertyName = "S"

        Dim allColumns As DataGridViewColumn() = {col1, col2}

        If names Is Nothing OrElse names.Length = 0 Then
            Return allColumns
        End If

        Dim returnColumsList As New List(Of DataGridViewColumn)
        For Each dgvc In allColumns
            If names.Contains(dgvc.Name) Then returnColumsList.Add(dgvc)
        Next
        Return returnColumsList.ToArray()

    End Function

End Class ' mc

