Imports System.Drawing.Drawing2D
Public Class Form1

  ' vb@rchiv - Das groe Visual Basic Archiv
  '
  ' Copyright 2000-2010 Dieter Otter
  '
  ' Der Programmcode darf fr eigene Zwecke verwendet werden.
  ' Es ist nicht erlaubt Inhalte des Projektes (Source) ohne unserer
  ' Zustimmung zum Download anzubieten.
  '
  ' Die Beispielskripte sind Computerprogramme, die gem
  ' des 2 Abs. 1 Nr. 69 aff. UrhG den urheberrechtlichen
  ' Schutz geniessen und drfen nicht fr eigene ausgegeben
  ' werden.
  '
  ' Dieter Otter
  ' Software-Entwicklung & Vertrieb
  ' info@vbarchiv.de
  ' http://www.vbarchiv.de
  '
  ' info@tools4vb.de
  ' http://www.tools4vb.de
  '======================================================

  ' API-Deklarationen
  Private Declare Function SHFileOperation Lib "shell32.dll" _
    Alias "SHFileOperationA" ( _
    ByRef lpFileOp As SHFILEOPSTRUCT) As Integer

  Private Structure SHFILEOPSTRUCT
    Dim hwnd As IntPtr
    Dim wFunc As Integer
    Dim pFrom As String
    Dim pTo As String
    Dim fFlags As Short
    Dim fAnyOperationsAborted As Boolean
    Dim hNameMappings As Integer
    Dim lpszProgressTitle As String
  End Structure

  Private Const FN_COPY As Integer = &H2&
  Private Const FnF_RENAMEONCOLLISION = &H8&
  Private Const FnF_MULTIDESTFILES = &H1&
  Private Const FnF_FILESONLY = &H80&

  ''' <summary>
  ''' Kopiert eine oder mehrere Dateien mit Hilfe des Windows Dialogs
  ''' </summary>
  ''' <param name="SourceFile">Quelldatei(en)</param>
  ''' <param name="DestPath">Ziel-Ordner</param>
  ''' <param name="Overwrite">True, wenn vorhandene Dateien berschrieben 
  ''' werden sollen, andernfalls False.</param>
  ''' <returns>Mehrere Dateien mssen mit 2 x Chr(0) voneinander getrennt 
  ''' bergeben werden.</returns>
  Public Function CopyFileShell(ByVal SourceFile As String, _
    ByVal DestPath As String, _
    ByVal Overwrite As Boolean) As Boolean

    Dim SFO As New SHFILEOPSTRUCT
    Dim Flags As Short = 0

    ' berschreiben?
    If Overwrite Then Flags = Flags Or FnF_RENAMEONCOLLISION

    ' Mehrere Dateien kopieren
    If SourceFile.Contains(Chr(0) & Chr(0)) Then
      Flags = Flags Or FnF_MULTIDESTFILES
    End If
    If SourceFile.Contains("*") Then
      Flags = Flags Or FnF_FILESONLY
    End If

    With SFO
      .wFunc = FN_COPY
      .pFrom = SourceFile.TrimEnd(Chr(0)) & Chr(0) & Chr(0)
      .pTo = DestPath
      .fFlags = Flags
    End With

    Return (SHFileOperation(SFO) = 0)
  End Function


  Private Sub imgLogo_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles imgLogo.Click
    ' URL laden
    System.Diagnostics.Process.Start("http://www.vbarchiv.net")
  End Sub

  Private Sub lnkURL_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles lnkURL.Click
    ' URL laden
    System.Diagnostics.Process.Start("http://www.vbarchiv.net")
  End Sub

  Private Sub Panel2_Paint(ByVal sender As Object, ByVal e As System.Windows.Forms.PaintEventArgs) Handles Panel2.Paint
    ' Hintergrund-Farbverlauf erstellen
    ' Gre der Form
    Dim oRect As New Rectangle(0, 0, Panel2.Width, Panel2.Height)

    ' Neues Brush-Objekt mit den gewnschten Farben und
    ' Farbverlauf-Richtung erstellen
    Dim oBrush As New LinearGradientBrush(oRect, Color.FromArgb(255, 231, 247, 255), Color.FromArgb(255, 181, 214, 255), _
      LinearGradientMode.Vertical)

    ' Hintergrund-Farbverlauf anzeigen
    e.Graphics.FillRectangle(oBrush, oRect)
  End Sub

  Private Sub Panel1_Paint(ByVal sender As Object, ByVal e As System.Windows.Forms.PaintEventArgs) Handles Panel1.Paint
    ' Hintergrund-Farbverlauf erstellen
    ' Gre der Form
    Dim oRect As New Rectangle(0, 0, Panel1.Width, Panel1.Height)

    ' Neues Brush-Objekt mit den gewnschten Farben und
    ' Farbverlauf-Richtung erstellen
    Dim oBrush As New LinearGradientBrush(oRect, Color.FromArgb(255, 231, 247, 255), Color.FromArgb(255, 181, 214, 255), _
      LinearGradientMode.Vertical)

    ' Hintergrund-Farbverlauf anzeigen
    e.Graphics.FillRectangle(oBrush, oRect)
  End Sub

  Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button1.Click
    ' Datei auswhlen
    With New OpenFileDialog
      .Filter = "alle Dateien (*.*)|*.*"
      If .ShowDialog = Windows.Forms.DialogResult.OK Then
        txtFile.Text = .FileName
      End If
    End With
  End Sub

  Private Sub Button2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button2.Click
    ' Ordner auswhlen
    With New FolderBrowserDialog
      If .ShowDialog = Windows.Forms.DialogResult.OK Then
        txtPath.Text = .SelectedPath
      End If
    End With
  End Sub

  Private Sub txtFile_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles txtFile.TextChanged, txtPath.TextChanged
    Button3.Enabled = (txtFile.TextLength > 0 AndAlso txtPath.TextLength > 0)
  End Sub

  Private Sub Button3_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button3.Click
    ' Kopiervorhang starten
    If CopyFileShell(txtFile.Text, txtPath.Text, False) Then
      MsgBox("Kopiervorgang erfolgreich abgeschlossen!", MsgBoxStyle.Information)
    Else
      MsgBox("Kopiervorgang wurde abgebrochen!", MsgBoxStyle.Exclamation)
    End If
  End Sub
End Class
