VERSION 5.00
Begin {C62A69F0-16DC-11CE-9E98-00AA00574A4F} dhMarkNumberOfChars 
   Caption         =   "Zeichen markieren"
   ClientHeight    =   3870
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   2325
   OleObjectBlob   =   "dhMarkNumberOfChars.frx":0000
   StartUpPosition =   1  'Fenstermitte
End
Attribute VB_Name = "dhMarkNumberOfChars"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Dim Seite, Zeile, Steps, Zeichen, wdIdx As Integer
Dim calcSteps As Integer, markColor As Long, picColor As String
Dim iColors(), eColors(), nColors(), aIdx() As Variant

Private Sub CommandButton1_Click()  'Aktion ausfhren
    getAllCharnumbersOfChapter "berschrift A"  'bestimmtes Absatzformat vorgeben (Name)
    If CheckBox1.Value = True Then
        HeadLineSuchen "berschrift A"
    Else
        CursorPositionAuslesen
        calcSteps = Steps + CInt(TextBox1.text)
'        Application.ScreenUpdating = False
        CursorPositionBestimmen
'        Application.ScreenUpdating = True
    End If
End Sub

Private Sub CommandButton2_Click()  'Aktion abbrechen
    Unload Me
End Sub

Private Sub CommandButton3_Click()  'Aktion rckgngig
    ActiveDocument.Undo
End Sub

Private Sub markFarben_Change()
    If eColors(markFarben.ListIndex) <> "" Then
        picColor = "&H" + eColors(markFarben.ListIndex)
        With markFarben
            .BackColor = picColor
            .ForeColor = GetSWForeColor(picColor)
            .SelStart = Len(.List(.ListIndex))
            wdIdx = .ListIndex
        End With
    End If
End Sub

Private Sub UserForm_Initialize()
    nColors = Array("Auto", "Black", "Blue", "BrightGreen", "DarkBlue", "DarkRed", "DarkYellow", _
                "Gray25", "Gray50", "Green", "NoHighlight", "Pink", "Red", _
                "Teal", "Turquoise", "Violet", "White", "Yellow")
    eColors = Array("", "0", "FF0000", "32CD32", "800000", "8B", "2F6B55", _
                "A9A9A9", "696969", "6400", "", "8515C7", "FF", _
                "808000", "D0E040", "EE82EE", "FFFFFF", "FFFF")
    iColors = Array(wdAuto, wdBlack, wdBlue, wdBrightGreen, wdDarkBlue, wdDarkRed, wdDarkYellow, _
                wdGray25, wdGray50, wdGreen, wdNoHighlight, wdPink, wdRed, _
                wdTeal, wdTurquoise, wdViolet, wdWhite, wdYellow)
    For i = 0 To UBound(iColors)
        markFarben.AddItem nColors(i)   'kann auch anderes Feld verwendet werden
    Next
    markFarben.ListIndex = i - 1
    wdIdx = i - 1
    Label2.Caption = "0"
    TextBox1.text = "4500"  'Vorgabewert fr Zeichenanzahl
    calcSteps = CInt(TextBox1.text)
    
    Zeichen = ActiveDocument.ComputeStatistics(wdStatisticCharactersWithSpaces)
End Sub

Private Sub UserForm_Activate()
    CursorPositionAuslesen
    TextBox1.SelStart = 0
End Sub

Sub CursorPositionAuslesen()
    With selection
        Seite = .Information(wdActiveEndPageNumber)
        Zeile = .Information(wdFirstCharacterLineNumber)
        Steps = .Information(wdFirstCharacterColumnNumber) - 1
    End With
    
    Label2.Caption = "Seite  " & _
           Seite & ", Zeile  " & Zeile & ", " & Steps & "  Schritte von links "
End Sub

Sub CursorPositionBestimmen()   'mit gleichzeitigem Markieren des Texts
    With selection
        .HomeKey unit:=wdStory
        .GoTo What:=wdGoToPage, Count:=Seite
        .MoveDown unit:=wdLine, Count:=Zeile - 1
        .MoveRight unit:=wdCharacter, Count:=calcSteps, Extend:=Word.WdMovementType.wdExtend
        .Range.HighlightColorIndex = iColors(wdIdx)
        .Select
    End With
End Sub

Sub HeadLineSuchen(hdl As String)    'bei automatischem Betrieb fr "alle"
    Dim rngErgebnis As Range         'bestimmte vorgegebene berschrift (Absatzformat) suchen
    Dim bGefunden As Boolean
    
    Application.ScreenUpdating = False
    Set rngErgebnis = ActiveDocument.Content.Duplicate
    rngErgebnis.Find.Style = ActiveDocument.Styles(hdl)
    Do
        With rngErgebnis.Find
            .Forward = True
            .Wrap = wdFindStop
            .Execute
            bGefunden = .Found
        End With
        If bGefunden Then
            With rngErgebnis
                .Select
                CursorPositionAuslesen
                CursorPositionBestimmen
            End With
        Else
            Exit Do
        End If
    Loop
    Application.ScreenUpdating = True
    selection.HomeKey wdStory
End Sub

Sub getAllCharnumbersOfChapter(hdu As String)     'Zeichenzahl zwischen zwei berschriften
    Dim rngErgebnis As Range
    Dim bGefunden As Boolean
    Dim iAnz As Double
    
    Application.ScreenUpdating = False
    Set rngErgebnis = ActiveDocument.Content.Duplicate
    rngErgebnis.Find.Style = ActiveDocument.Styles(hdu)
    iAnz = 0
    Do
        With rngErgebnis.Find
            .Forward = True
            .Wrap = wdFindStop
            .Execute
            bGefunden = .Found
        End With
        If bGefunden Then   'berschrift gefunden
            With rngErgebnis
                .Select
            End With
            ReDim Preserve aIdx(iAnz)
            aIdx(iAnz) = Here
'            Debug.Print CStr(iAnz) + " - " + CStr(anzChars1) + " - " + CStr(anzChars2)
            iAnz = iAnz + 1
        Else
            Exit Do
        End If
    Loop
    Application.ScreenUpdating = True
    selection.HomeKey wdStory
    
    Dim summ As Double
    summ = 0
    For i = 1 To UBound(aIdx)
        summ = summ + aIdx(i) - aIdx(i - 1) - 4500
    Next
    Debug.Print Abs(summ)
    Debug.Print Format(Abs(summ) / Zeichen, "0 %")
End Sub

Private Sub UserForm_QueryClose(Cancel As Integer, CloseMode As Integer)
    Unload Me
End Sub
